<?php 

/**
* Класс для отправки почты
* Автор: alex-borisi
* ICQ:   587863132
* Сайт:  http://nasimbe.ru
*/

class EmailSender
{
    public function __construct() {

    }
    
    /**
    * Cоздаем заголовок
    */
    public function getHeaders($headers, $boundary) {
        $data[] = "MIME-Version: 1.0";
        $data[] = "Content-type: multipart/mixed; boundary=\"$boundary\"";
        $data[] = "To: $headers[to]";
        $data[] = "From: $headers[subject] <$headers[from]>";
        $data[] = "Reply-To: $headers[from]"; 
        $headers = implode("\r\n", $data);
        
        return $headers;
    }
    
    /**
    * Cоздаем тело с сообщением
    */
    public function getBody($body, $boundary) {
      
        $multipart[] = "--$boundary"; 
        $multipart[] = "Content-Type: text/plain; charset=utf-8";
        $multipart[] = "Content-Transfer-Encoding: base64";    
        $multipart[] = "\r\n";
        $multipart[] = chunk_split(base64_encode($body));
        
        // Крепим файлы если есть
        $attachments = new Attachments();
        $multipart[] = $attachments->get_attachments($boundary);
        
        return implode("\r\n", $multipart);
    }
    
    /**
    * Отправляет сообщение 
    */
    public function mail($to, $subject, $message, $headers, $returnPath)
    {
        $result = null;
        
        if (!mail($to, $subject, $message, $headers, '-f' . $returnPath)) {
            $result = 'Не удалось отправить Email сообщение';
        }
        
        return ($result ? array('error' => $result) : 'OK');
    } 
}